/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.api.client.ColorSettings;
import corgitaco.enhancedcelestials.mixin.access.ColorAccess;
import corgitaco.enhancedcelestials.mixin.access.StyleAccess;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;

public class CodecUtil {
    public static final Codec<ClickEvent.Action> CLICK_EVENT_ACTION_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)ClickEvent.Action.valueOf((String)s));
        }
        catch (Exception e) {
            EnhancedCelestials.LOGGER.error(e.getMessage());
            return DataResult.error((String)e.getMessage());
        }
    }, Enum::name);
    public static final Codec<ClickEvent> CLICK_EVENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CLICK_EVENT_ACTION_CODEC.fieldOf("action").forGetter(clickEvent -> clickEvent.m_130622_()), (App)Codec.STRING.fieldOf("value").forGetter(clickEvent -> clickEvent.m_130623_())).apply((Applicative)builder, ClickEvent::new));
    public static final Codec<Style> STYLE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("color", (Object)"").forGetter(style -> style.m_131135_() != null ? Integer.toHexString(((ColorAccess)style.m_131135_()).getColorRaw()) : Integer.toHexString(ChatFormatting.WHITE.m_126665_())), (App)Codec.BOOL.optionalFieldOf("bold", (Object)false).forGetter(style -> style.m_131154_()), (App)Codec.BOOL.optionalFieldOf("italic", (Object)false).forGetter(style -> style.m_131161_()), (App)Codec.BOOL.optionalFieldOf("underlined", (Object)false).forGetter(style -> style.m_131171_()), (App)Codec.BOOL.optionalFieldOf("strikethrough", (Object)false).forGetter(style -> style.m_131168_()), (App)Codec.BOOL.optionalFieldOf("obfuscated", (Object)false).forGetter(style -> style.m_131176_()), (App)CLICK_EVENT_CODEC.optionalFieldOf("clickEvent").forGetter(style -> style.m_131182_() != null ? Optional.of(style.m_131182_()) : Optional.empty())).apply((Applicative)builder, (color, bold, italic, underlined, strikethrough, obfuscated, clickEvent) -> StyleAccess.create(ColorAccess.create(ColorSettings.tryParseColor(color)), bold, italic, underlined, strikethrough, obfuscated, clickEvent.orElse(null), null, null, null)));

    public record LazyCodec<TYPE>(Supplier<Codec<TYPE>> delegate) implements Codec<TYPE>
    {
        public <T> DataResult<T> encode(TYPE input, DynamicOps<T> ops, T prefix) {
            return this.delegate().get().encode(input, ops, prefix);
        }

        public <T> DataResult<Pair<TYPE, T>> decode(DynamicOps<T> ops, T input) {
            return this.delegate().get().decode(ops, input);
        }
    }
}

